// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO COMPUTE LINEAR CONVOLUTION OF TWO SEQUENCES USING BASIC EQUATION
clc;
clear;
close;
//input sequences
x=input('Enter the Input Sequence x(n)=') //x=[1 2 3 1]
m=length(x);
xl=input('Enter the lower index of Input Sequence=')//0
xh=xl+m-1;
n=xl:1:xh;
subplot(3,1,1);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,x);
title('Input Sequence x[n]');
xlabel('Samples n');
ylabel('Amplitude');

h=input('Enter the Impulse response Sequence h(n)=');//h=[1 2 1 -1]
l=length(h);
hl=input('Enter the lower index of Impulse response Sequence=');//-1
hh=hl+l-1;
g=hl:1:hh;
subplot(3,1,2);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,h);
title('Impulse Response Sequence h[n]');
xlabel('Samples n');
ylabel('Amplitude');

nx=xl+hl; // range of k
nh=xh+hh;// range of n
x=[x,zeros(1,l)];
h=[h,zeros(1,m)];
y=zeros(1,m+l-1)// n1+n2-1=length of linear convolution
for i=1:m+l-1
    y(i)=0;
    for j=1:m+l-1
        if(j<i+1)
            y(i)=y(i)+x(j)*h(i-j+1);
            end
    end
end
disp('Linear Convolution using Equation is y(n):') 
disp(y);
r=nx:nh;
subplot(3,1,3);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,y);
title('Output Response Sequence of Linear Convolution using Equation y[n]');
xlabel('Samples n');
ylabel('Amplitude');
//INPUT:
//Enter the Input Sequence x(n)=[1 2 3 1]
//Enter the lower index of Input Sequence=0
//Enter the Impulse response Sequence h(n)=[1 2 1 -1]
//Enter the lower index of Impulse response Sequence=-1
 
 //OUTPUT:
 //Linear Convolution using Equation is y(n):   
 
   // 1.    4.    8.    8.    3.  - 2.  - 1.  
 
